/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Cracker;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Selection;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListModel;

public class VersionInfoDialog
extends JDialog {
    private static final long serialVersionUID = -7743402150436285214L;
    List<Item> list;
    Game game;
    boolean isList;
    Cracker cracker;
    private JPanel chooseCrackerPanel;
    private JButton crackerButton;
    private JTextField crackerTextField;
    private JList crackersList;
    private JCheckBox highScoreSaverCheckbox;
    private JCheckBox includeCrackerCheckbox;
    private JCheckBox includeHighScoreSaverCheckbox;
    private JCheckBox includeIncludedDocsCheckbox;
    private JCheckBox includeLengthCheckbox;
    private JCheckBox includeLoadingScreenCheckbox;
    private JCheckBox includeNoOfTrainersCheckbox;
    private JCheckBox includePalNtscCheckbox;
    private JCheckBox includeTrueDriveEmulationCheckbox;
    private JCheckBox includeVersionCommentCheckbox;
    private JCheckBox includedDocsCheckbox;
    private JComboBox lengthComboBox;
    private JTextField lengthTextField;
    private JCheckBox loadingScreenCheckbox;
    private JComboBox noOfTrainersComboBox;
    private JComboBox palNtscComboBox;
    private JTabbedPane propertiesPane;
    private JCheckBox trueDriveEmulationCheckbox;
    private JTextField versionCommentTextField;

    public VersionInfoDialog(Game game) {
        this.isList = false;
        this.game = game;
        this.initComponents();
        this.selectIncludes(true);
        this.propertiesPane.remove(0);
        this.cracker = game.getCracker();
        this.crackerTextField.setText(this.cracker.getName());
        this.noOfTrainersComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Trainers", 4, 3, 0, "Games", "V_Trainers", "", "").getSelections().toArray()));
        int i = 0;
        while (i < this.noOfTrainersComboBox.getModel().getSize()) {
            if (((Selection)this.noOfTrainersComboBox.getModel().getElementAt(i)).getValue().equals(String.valueOf(game.getTrainer()))) {
                this.noOfTrainersComboBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.palNtscComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_PALNTSC));
        this.palNtscComboBox.setSelectedIndex(game.getPalNtsc());
        this.lengthTextField.setText(String.valueOf(Math.abs(game.getLength())));
        this.lengthComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_LENGTHTYPE));
        this.lengthComboBox.setSelectedIndex(game.getLengthType());
        this.highScoreSaverCheckbox.setSelected(game.getHasHighscoreSaver());
        this.loadingScreenCheckbox.setSelected(game.getHasLoadingScreen());
        this.includedDocsCheckbox.setSelected(game.getHasIncludedDocs());
        this.trueDriveEmulationCheckbox.setSelected(game.getNeedsTruedriveEmu());
        this.versionCommentTextField.setText(game.getVersionComment());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public VersionInfoDialog(List<Item> list) {
        this.isList = true;
        this.list = list;
        this.initComponents();
        this.selectIncludes(false);
        this.cracker = Db.getCrackerById(7);
        this.crackerTextField.setText(this.cracker.getName());
        this.noOfTrainersComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Cracker", 4, 3, 0, "Games", "V_Trainers", "", "").getSelections().toArray()));
        this.palNtscComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_PALNTSC));
        this.palNtscComboBox.setSelectedIndex(3);
        this.lengthComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_LENGTHTYPE));
        this.setVisible(true);
    }

    private void initComponents() {
        this.chooseCrackerPanel = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.crackersList = new JList();
        JButton newCrackerButton = new JButton();
        JButton editCrackerButton = new JButton();
        this.propertiesPane = new JTabbedPane();
        Gui.fixLookAndFeel(this.propertiesPane);
        JPanel includePanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.includeCrackerCheckbox = new JCheckBox();
        this.includeTrueDriveEmulationCheckbox = new JCheckBox();
        this.includeNoOfTrainersCheckbox = new JCheckBox();
        this.includeLoadingScreenCheckbox = new JCheckBox();
        this.includeHighScoreSaverCheckbox = new JCheckBox();
        this.includeIncludedDocsCheckbox = new JCheckBox();
        this.includeLengthCheckbox = new JCheckBox();
        this.includeVersionCommentCheckbox = new JCheckBox();
        this.includePalNtscCheckbox = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JButton includeAllButton = new JButton();
        JButton includeNoneButton = new JButton();
        JPanel fieldsPanel = new JPanel();
        JLabel crackerLabel = new JLabel();
        this.noOfTrainersComboBox = new JComboBox();
        JLabel noOfTrainersLabel = new JLabel();
        this.crackerTextField = new JTextField();
        this.crackerButton = new JButton();
        JLabel lengthLabel = new JLabel();
        JLabel palNtscLabel = new JLabel();
        this.palNtscComboBox = new JComboBox();
        this.highScoreSaverCheckbox = new JCheckBox();
        JLabel versionCommentLabel = new JLabel();
        this.versionCommentTextField = new JTextField();
        this.loadingScreenCheckbox = new JCheckBox();
        this.includedDocsCheckbox = new JCheckBox();
        this.trueDriveEmulationCheckbox = new JCheckBox();
        this.lengthTextField = new JTextField();
        this.lengthComboBox = new JComboBox();
        JPanel jPanel3 = new JPanel();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.chooseCrackerPanel.setBorder(BorderFactory.createTitledBorder("Crackers"));
        this.chooseCrackerPanel.setLayout(new GridBagLayout());
        this.crackersList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.crackersList.setSelectionMode(0);
        jScrollPane1.setViewportView(this.crackersList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.chooseCrackerPanel.add((Component)jScrollPane1, gridBagConstraints);
        newCrackerButton.setMnemonic('N');
        newCrackerButton.setText("New");
        newCrackerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.newCrackerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        this.chooseCrackerPanel.add((Component)newCrackerButton, gridBagConstraints);
        editCrackerButton.setMnemonic('E');
        editCrackerButton.setText("Edit");
        editCrackerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.editCrackerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.chooseCrackerPanel.add((Component)editCrackerButton, gridBagConstraints);
        this.setTitle("Version Info Properties...");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VersionInfoDialog.this.exitFormWindowClosing(evt);
            }
        });
        includePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        includePanel.setLayout(new GridLayout(2, 1));
        jPanel1.setBorder(BorderFactory.createTitledBorder("Fields to update"));
        jPanel1.setLayout(new GridLayout(5, 2));
        this.includeCrackerCheckbox.setMnemonic('C');
        this.includeCrackerCheckbox.setText("Cracker");
        this.includeCrackerCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeCrackerCheckbox);
        this.includeTrueDriveEmulationCheckbox.setMnemonic('T');
        this.includeTrueDriveEmulationCheckbox.setText("True Drive Emulation");
        this.includeTrueDriveEmulationCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeTrueDriveEmulationCheckbox);
        this.includeNoOfTrainersCheckbox.setMnemonic('N');
        this.includeNoOfTrainersCheckbox.setText("Number of Trainers");
        this.includeNoOfTrainersCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeNoOfTrainersCheckbox);
        this.includeLoadingScreenCheckbox.setMnemonic('L');
        this.includeLoadingScreenCheckbox.setText("Loading Screen");
        this.includeLoadingScreenCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeLoadingScreenCheckbox);
        this.includeHighScoreSaverCheckbox.setMnemonic('H');
        this.includeHighScoreSaverCheckbox.setText("High Score Saver");
        this.includeHighScoreSaverCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeHighScoreSaverCheckbox);
        this.includeIncludedDocsCheckbox.setMnemonic('I');
        this.includeIncludedDocsCheckbox.setText("Included Docs");
        this.includeIncludedDocsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeIncludedDocsCheckbox);
        this.includeLengthCheckbox.setMnemonic('G');
        this.includeLengthCheckbox.setText("Game Length");
        this.includeLengthCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeLengthCheckbox);
        this.includeVersionCommentCheckbox.setMnemonic('e');
        this.includeVersionCommentCheckbox.setText("Version Comment");
        this.includeVersionCommentCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeVersionCommentCheckbox);
        this.includePalNtscCheckbox.setMnemonic('P');
        this.includePalNtscCheckbox.setText("PAL/NTSC");
        this.includePalNtscCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includePalNtscCheckbox);
        includePanel.add(jPanel1);
        jPanel2.setLayout(new FlowLayout(0));
        includeAllButton.setMnemonic('A');
        includeAllButton.setText("Select All");
        includeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.selectAllIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeAllButton);
        includeNoneButton.setMnemonic('N');
        includeNoneButton.setText("Select None");
        includeNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.selectNoneIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeNoneButton);
        includePanel.add(jPanel2);
        this.propertiesPane.addTab("Include", includePanel);
        fieldsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        fieldsPanel.setLayout(new GridBagLayout());
        crackerLabel.setDisplayedMnemonic('r');
        crackerLabel.setLabelFor(this.crackerButton);
        crackerLabel.setText("Cracker:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        fieldsPanel.add((Component)crackerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 15, 5);
        fieldsPanel.add((Component)this.noOfTrainersComboBox, gridBagConstraints);
        noOfTrainersLabel.setDisplayedMnemonic('N');
        noOfTrainersLabel.setLabelFor(this.noOfTrainersComboBox);
        noOfTrainersLabel.setText("No. of Trainers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        fieldsPanel.add((Component)noOfTrainersLabel, gridBagConstraints);
        this.crackerTextField.setEditable(false);
        this.crackerTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.crackerTextField, gridBagConstraints);
        this.crackerButton.setText("...");
        this.crackerButton.setMargin(new Insets(0, 10, 0, 10));
        this.crackerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.chooseOrEditCrackerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.crackerButton, gridBagConstraints);
        lengthLabel.setDisplayedMnemonic('G');
        lengthLabel.setLabelFor(this.lengthTextField);
        lengthLabel.setText("Game Length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        fieldsPanel.add((Component)lengthLabel, gridBagConstraints);
        palNtscLabel.setDisplayedMnemonic('P');
        palNtscLabel.setLabelFor(this.palNtscComboBox);
        palNtscLabel.setText("PAL/NTSC:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        fieldsPanel.add((Component)palNtscLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 50, 15, 0);
        fieldsPanel.add((Component)this.palNtscComboBox, gridBagConstraints);
        this.highScoreSaverCheckbox.setMnemonic('H');
        this.highScoreSaverCheckbox.setText("High Score Saver");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.highScoreSaverCheckbox, gridBagConstraints);
        versionCommentLabel.setDisplayedMnemonic('V');
        versionCommentLabel.setLabelFor(this.versionCommentTextField);
        versionCommentLabel.setText("Version Comment:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        fieldsPanel.add((Component)versionCommentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0833;
        fieldsPanel.add((Component)this.versionCommentTextField, gridBagConstraints);
        this.loadingScreenCheckbox.setMnemonic('L');
        this.loadingScreenCheckbox.setText("Loading Screen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.loadingScreenCheckbox, gridBagConstraints);
        this.includedDocsCheckbox.setMnemonic('D');
        this.includedDocsCheckbox.setText("Included Docs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.includedDocsCheckbox, gridBagConstraints);
        this.trueDriveEmulationCheckbox.setMnemonic('T');
        this.trueDriveEmulationCheckbox.setText("True Drive Emulation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.trueDriveEmulationCheckbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 15, 5);
        fieldsPanel.add((Component)this.lengthTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0833;
        gridBagConstraints.insets = new Insets(0, 0, 15, 50);
        fieldsPanel.add((Component)this.lengthComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.weighty = 1.0;
        fieldsPanel.add((Component)jPanel3, gridBagConstraints);
        this.propertiesPane.addTab("Fields", fieldsPanel);
        this.getContentPane().add((Component)this.propertiesPane, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VersionInfoDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void chooseOrEditCrackerActionPerformed(ActionEvent evt) {
        this.crackersList.setModel(new ListListModel(new ItemViewFilter("Cracker", 2, 3, 0, "Crackers", "CR_Id", "", "").getSelections()));
        int i = 0;
        while (i < this.crackersList.getModel().getSize()) {
            if (((Selection)this.crackersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.cracker.getId()))) {
                this.crackersList.setSelectedIndex(i);
                this.crackersList.ensureIndexIsVisible(i);
            }
            ++i;
        }
        if (JOptionPane.showOptionDialog(this, this.chooseCrackerPanel, "Select Cracker...", 2, -1, null, null, null) == 0) {
            this.cracker = Db.getCrackerById(Integer.parseInt(((Selection)this.crackersList.getSelectedValue()).getValue()));
            this.crackerTextField.setText(this.cracker.getName());
        }
    }

    private void newCrackerActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(this, "Name of Cracker", "New Cracker", -1, null, null, null);
        if (s != null && !s.isEmpty()) {
            this.cracker = new Cracker();
            this.cracker.setName(s);
            Db.saveOrUpdate(this.cracker);
            this.crackersList.setModel(new ListListModel(new ItemViewFilter("Cracker", 2, 3, 0, "Crackers", "CR_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.crackersList.getModel().getSize()) {
                if (((Selection)this.crackersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.cracker.getId()))) {
                    this.crackersList.setSelectedIndex(i);
                    this.crackersList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.crackerTextField.setText(s);
        }
    }

    private void includesChangedActionPerformed(ActionEvent evt) {
        this.includesChanged();
    }

    private void selectNoneIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(false);
    }

    private void editCrackerActionPerformed(ActionEvent evt) {
        Selection current = (Selection)this.crackersList.getSelectedValue();
        String s = (String)JOptionPane.showInputDialog(this, "Name of Cracker", "Edit Cracker", -1, null, null, current.getName());
        if (s != null && !s.isEmpty() && !s.equals(current.toString())) {
            this.cracker = Db.getCrackerById(Integer.parseInt(current.getValue()));
            this.cracker.setName(s);
            Db.saveOrUpdate(this.cracker);
            this.crackersList.setModel(new ListListModel(new ItemViewFilter("Cracker", 2, 3, 0, "Crackers", "CR_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.crackersList.getModel().getSize()) {
                if (((Selection)this.crackersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.cracker.getId()))) {
                    this.crackersList.setSelectedIndex(i);
                    this.crackersList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.crackerTextField.setText(s);
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void selectAllIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(true);
    }

    private void selectIncludes(boolean b) {
        this.includeCrackerCheckbox.setSelected(b);
        this.includeNoOfTrainersCheckbox.setSelected(b);
        this.includePalNtscCheckbox.setSelected(b);
        this.includeLengthCheckbox.setSelected(b);
        this.includeHighScoreSaverCheckbox.setSelected(b);
        this.includeLoadingScreenCheckbox.setSelected(b);
        this.includeIncludedDocsCheckbox.setSelected(b);
        this.includeTrueDriveEmulationCheckbox.setSelected(b);
        this.includeVersionCommentCheckbox.setSelected(b);
        this.includesChanged();
    }

    private void includesChanged() {
        this.crackerTextField.setEnabled(this.includeCrackerCheckbox.isSelected());
        this.crackerTextField.setBackground(this.includeCrackerCheckbox.isSelected() ? new Color(255, 255, 204) : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.crackerButton.setEnabled(this.includeCrackerCheckbox.isSelected());
        this.noOfTrainersComboBox.setEnabled(this.includeNoOfTrainersCheckbox.isSelected());
        this.palNtscComboBox.setEnabled(this.includePalNtscCheckbox.isSelected());
        this.lengthTextField.setEnabled(this.includeLengthCheckbox.isSelected());
        this.lengthComboBox.setEnabled(this.includeLengthCheckbox.isSelected());
        this.highScoreSaverCheckbox.setEnabled(this.includeHighScoreSaverCheckbox.isSelected());
        this.loadingScreenCheckbox.setEnabled(this.includeLoadingScreenCheckbox.isSelected());
        this.includedDocsCheckbox.setEnabled(this.includeIncludedDocsCheckbox.isSelected());
        this.trueDriveEmulationCheckbox.setEnabled(this.includeTrueDriveEmulationCheckbox.isSelected());
        this.versionCommentTextField.setEditable(this.includeVersionCommentCheckbox.isSelected());
    }

    private void okActionPerformed(ActionEvent evt) {
        if (!this.isList) {
            this.list = new ArrayList<Item>();
            this.list.add(this.game);
        }
        for (Item item : this.list) {
            if (!(item instanceof Game)) continue;
            Game game = (Game)item;
            if (this.includeCrackerCheckbox.isSelected()) {
                game.setCracker(this.cracker);
            }
            if (this.includeNoOfTrainersCheckbox.isSelected()) {
                game.setTrainer(Integer.parseInt(((Selection)this.noOfTrainersComboBox.getSelectedItem()).getValue()));
            }
            if (this.includePalNtscCheckbox.isSelected()) {
                game.setPalNtsc(this.palNtscComboBox.getSelectedIndex());
            }
            if (this.includeLengthCheckbox.isSelected()) {
                game.setLength(Integer.parseInt(this.lengthTextField.getText()));
                game.setLengthType(this.lengthComboBox.getSelectedIndex());
            }
            if (this.includeHighScoreSaverCheckbox.isSelected()) {
                game.setHasHighscoreSaver(this.highScoreSaverCheckbox.isSelected());
            }
            if (this.includeLoadingScreenCheckbox.isSelected()) {
                game.setHasLoadingScreen(this.loadingScreenCheckbox.isSelected());
            }
            if (this.includeIncludedDocsCheckbox.isSelected()) {
                game.setHasIncludedDocs(this.includedDocsCheckbox.isSelected());
            }
            if (this.includeTrueDriveEmulationCheckbox.isSelected()) {
                game.setNeedsTruedriveEmu(this.trueDriveEmulationCheckbox.isSelected());
            }
            if (this.includeVersionCommentCheckbox.isSelected()) {
                game.setVersionComment(this.versionCommentTextField.getText());
            }
            Db.saveOrUpdate(game);
        }
        this.dispose();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

